#include "Coordinates_frame.h"

#include "Atom.h"
#include "Atom_group.h"
#include "Point_3D_impl.h"
#include "Vector_3D_impl.h"
#include "Affine_combination.h"
#include "Linear_combination_handler.h"

namespace MM
{

Coordinates_frame::
Coordinates_frame (Atom_group & group)
:
    group_(group)
{
}

int Coordinates_frame::
size () const
{
    return 3 * group_.atom_count();
}

void Coordinates_frame::
get (double *values) const
{
    for (int i=0;  i<group_.atom_count(); ++i)
    {
        Atom & atom = group_.atom (i);
        *values++ = atom.x();
        *values++ = atom.y();
        *values++ = atom.z();
        //group_.atom(i).position().get (values);
    }
}

void Coordinates_frame::
set (double const* new_values)
{
    for (int i=0;  i<group_.atom_count(); ++i)
    {
        //atom(i).set_x (new_values++);
        //atom(i).set_y (new_values++);
        //atom(i).set_z (new_values++);
        group_.atom(i).set_position
            (Point_3D_impl (*new_values++, *new_values++, *new_values++));
    }
}

void Coordinates_frame::
add (double const* values)
{
    //group_.kit().clear_force ();

    for (int i=0;  i<group_.atom_count(); ++i)
    {
        //atom(i) += Vector_3D_impl (new_values++, new_values++, new_values++);
        group_.atom(i).move
            (Vector_3D_impl (*values++, *values++, *values++));
    }
}

/*void Coordinates_frame::
add_scaled (double scale, double const* values)
{
    for (int i=0;  i<group_.atom_count(); ++i)
        //group_.atom(i).position().add_scaled (scale, values);
        group_.atom(i).move (Vector_3D_impl 
            (*values++ * scale, *values++ * scale, *values++ * scale));
}//*/

void Coordinates_frame::
multiply (double value)
{
    for (int i=0;  i<group_.atom_count(); ++i)
    {
        //group_.atom(i).position().multiply (value);
        Point_3D const& current = group_.atom(i).position();
        group_.atom(i).set_position (Point_3D_impl 
            (value * current.x(), value * current.y(), value * current.z()));
    }
}

/*Linear_combination_handler Coordinates_frame::
linear_combination (double a)
{
    return Linear_combination_handler (new Affine_combination (a));
}//*/

}//MM



