#include "Force.h"

#include "Atom.h"
#include "Atom_group.h"
#include "Atom_kit.h"

namespace MM
{
int Force::
size () const
{
    return 3 * group_.atom_count();
}

void Force::
get (double *values) const
{
    for (int i=0;  i<group_.atom_count(); ++i)
    {
        *values++ = group_.atom(i).kit().potential_force().x();
        *values++ = group_.atom(i).kit().potential_force().y();
        *values++ = group_.atom(i).kit().potential_force().z();
    }
}

}//MM

