#include "Gradient_frame.h"

#include "Atom.h"
#include "Atom_group.h"
#include "Atom_kit.h"

#include <math.h>

namespace MM
{
Gradient_frame::
Gradient_frame (Atom_group const & group)
:
    group_(group), norm_(0.), rms_(0.)
{
}

int Gradient_frame::
size () const
{
    return group_.atom_count();
}

void Gradient_frame::
get (double *values) const
{
    for (int i=0;  i<group_.atom_count(); ++i)
    {
        *values++ = - group_.atom(i).kit().potential_force().x();
        *values++ = - group_.atom(i).kit().potential_force().y();
        *values++ = - group_.atom(i).kit().potential_force().z();
    }
}

void Gradient_frame::
update ()
{
    double sum_2 = 0;
    double dimensions = 3;
    if (group_.atom_count() > 0)
        dimensions = group_.atom(0).kit().potential_force().dimensions();

    for (int i=0;  i<group_.atom_count(); ++i)
        sum_2 += group_.atom(i).kit().potential_force().length_2();

    norm_ = sqrt (sum_2);
    rms_  = sqrt (sum_2 / (dimensions * group_.atom_count()));
}

}//MM



