#include "Velocities.h"

#include "Atom.h"
#include "Atom_group.h"
#include "Atom_kit.h"
#include "Linear_combination.h"
#include "Linear_combination_handler.h"

namespace MM
{

int  Velocities::
size () const
{
    return 3 * group_.atom_count();
}

void Velocities::get (double *values) const
{
    for (int i=0;  i<group_.atom_count(); ++i)
    {
    //    group_.atom(i).kit().velocity().get (values);
        Vector_3D const& velocity = group_.atom(i).kit().velocity();
        *values++ = velocity.x();
        *values++ = velocity.y();
        *values++ = velocity.z();
    }
}

void Velocities::
set (double const* new_values)
{
    for (int i=0;  i<group_.atom_count(); ++i)
    {
        const Vector_3D_impl new_velocity 
            (*new_values++, *new_values++, *new_values++);

        group_.atom(i).kit().set_velocity (new_velocity);
    }
}

void Velocities::add (double const* values)
{
    for (int i=0;  i<group_.atom_count(); ++i)
    {
        group_.atom(i).kit().add_velocity
            (Vector_3D_impl (*values++, *values++, *values++));
    }
}

/*void Velocities::
add_scaled (double scale, double const* values)
{
    for (int i=0;  i<group_.atom_count(); ++i)
    {
        group_.atom(i).kit().add_velocity (Vector_3D_impl
            (*values++ * scale, *values++ * scale, *values++ * scale));
    }
}//*/

void Velocities::
multiply (double value)
{
    for (int i=0;  i<group_.atom_count(); ++i)
    {
        Vector_3D_impl current (group_.atom(i).kit().velocity());
        current *= value;
        group_.atom(i).kit().set_velocity (current);
    }
}

/*Linear_combination_handler Velocities::
linear_combination (double a)
{
    return Linear_combination_handler (new Linear_combination (a));
}//*/

}//MM

