#ifndef INITIALIZATION_STAGE_H
#define INITIALIZATION_STAGE_H

#ifndef PROTOCOL_STAGE_FRAME_H
#include "Protocol_stage_frame.h"
#endif

#ifndef MONITOR_H
#include "Monitor.h"
#endif

#ifndef TEMPERATURE_UNIT_H
#include "Temperature_unit.h"
#endif

#ifndef PRESSURE_UNIT_H
#include "Pressure_unit.h"
#endif

#include "Create.h"
//#include "__rand.h"

#ifdef WIN32
#pragma warning(disable : 4800)
#pragma warning(disable : 4996)
#endif
#include "MersenneTwister.h"

namespace MM
{
class Model;

class Initialization_stage : public Protocol_stage_frame
{
    Temperature_unit        temperature_;
    Pressure_unit           pressure_;
    //static T_Base_random    rand_;
    static MTRand          distr_;

public:
    explicit  Initialization_stage (Protocol &protocol, Text const & init);

    static void             setup_velocities (Atom_group &, 
                                              Temperature_unit const &);

    void                    execute ();
    void                    stop    ()                      {}
    void                    at_every_iteration (Command *)  {}

    virtual Text            option     (Text const & key) const;
    virtual void            set_option (Text const & key, Text const & value);
    virtual void            get_option (int i, Text & key, Text & value) const;
    virtual int             option_count () const;

//    Monitor &               monitor (int i)         {return nil <Monitor>();}
//    Monitor const &         monitor (int i)  const  {return nil <Monitor>();}
    Monitor &               monitor (int )         {return nil <Monitor>();}
    Monitor const &         monitor (int )  const  {return nil <Monitor>();}
    int                     monitor_count () const  {return 0;}

    void                    update (){;}
    void                    edit () {;}

protected:
    static double           gauss ();

};

}//MM

#endif //INITIALIZATION_STAGE_H
