#include "Intention.h"

#include "No_intention.h"
#include "Setup_initial_conditions_intention.h"
#include "Equilibration_intention.h"
#include "Production_intention.h"
#include "Heating_intention.h"
#include "Cooling_intention.h"
#include "Optimization_intention.h"
#include "Pause_intention.h"

#include "Flaw.h"

namespace MM
{

Intention * Intention::
create (Text const& init, Protocol_stage & stage)
{
    Intention * intention = none (stage);

    if (init == "Setup_initial_conditions" || init == "Initial_conditions")
        intention = new Setup_initial_conditions_intention (stage);

    else if (init == "Equilibration")
        intention = new Equilibration_intention (stage);

    else if (init == "Production")
        intention = new Production_intention (stage);

    /*else if (init == "Heating")
        intention = =urn new Heating_intention (stage);

    else if (init == "Cooling")
        intention = new Cooling_intention (stage);

    else if (init == "Optimization")
        intention = new Optimization_intention (stage);//*/

    else if (init == "Pause")
        intention = new Pause_intention (stage);

    intention->apply ();
    return intention;
}

Intention * Intention::
none (Protocol_stage & stage)
{
    Intention * result = new No_intention (stage);

    return result;
}

Intention::~Intention () {}

}//MM
