#ifndef INTENTION_FRAME_H
#define INTENTION_FRAME_H

#ifndef INTENTION_H
#include "Intention.h"
#endif

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

namespace MM
{
class Protocol_stage;

class Intention_frame : public Intention, protected DbC
{
protected:
    Text                title_;
    Text                last_message_;
    Protocol_stage &    stage_;

    void    set_message (Text const& text) {last_message_ = text;}

public:
    explicit Intention_frame (Text const & title, Protocol_stage & stage)
        :  title_(title), stage_(stage) {}

    Text const &        title () const              {return title_;}
    Text const &        last_message () const       {return last_message_;}
};

}//MM

#endif //INTENTION_FRAME_H
