#ifndef MODEL_SINGLETON_VIEW_H
#define MODEL_SINGLETON_VIEW_H

#ifndef COMMAND_H
#include "Command.h"
#endif

#ifndef MODEL_EVENT_H
#include "Model_event.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

namespace MM
{
class Model;
class Model_event;

class Model_singleton_view : protected DbC
{
    Command_1 <Model &> *               renew_current_model_;
    Command_1 <Model_event::Hint> *     renew_model_content_;
    
protected:
    Model *                             current_model_;

public:        
    explicit        Model_singleton_view();
    virtual        ~Model_singleton_view();

    virtual void    renew_current_model (Model &) =0;
    virtual void    renew (Model_event::Hint hint 
                         = Model_event::Structure_changed) =0;

private:
    virtual void    handle_renew_current_model (Model &);
    virtual void    setup_commands (Model &);
};

}//MM

#endif //MODEL_SINGLETON_VIEW_H
