#ifndef PAUSE_INTENTION_H
#define PAUSE_INTENTION_H

#ifndef INTENTION_FRAME_H
#include "Intention_frame.h"
#endif

#include "Duration_unit.h"
#include "Protocol_stage.h"

namespace MM
{

class Pause_intention : public Intention_frame
{
public:        
    explicit            Pause_intention (Protocol_stage & stage)
        : Intention_frame ("Pause", stage) {;}

    bool    check()
    {
        Duration_unit unit;     unit.from_text (stage_.option ("Length"));
        if (unit.sec() > 60 * 60 * 24)
        {
            set_message ("Pause is a longer than a day.");
            return false;
        }

        set_message ("");
        return true;
    }

    void    apply()         {;}
    bool    was_reached ()  {return true;}
};

}//MM

#endif //PAUSE_INTENTION_H
