#ifndef PROJECT_H
#define PROJECT_H

#ifndef DBC_H
#include "DbC.h"
#endif

#ifndef COMMAND_H
#include "Command.h"
#endif

namespace MM
{
class Project_kit;
class Model;

class Project :  protected DbC
{
public:
    static Project &            singleton ();
    virtual ~Project ();

    virtual Project_kit &       kit () =0;
    virtual Project_kit const & kit () const =0;

    virtual Model &             model           (int i) =0;
    virtual Model const &       model           (int i) const =0;
    virtual int                 model_count     () const =0;

    virtual Model &             current_model   () =0;
    virtual Model const &       current_model   () const =0;
    virtual void                set_current_model (Model &) =0;
    
    virtual void                on_change_current (Command_1 <Model&> *adoptee,
                                                   bool on = true) =0;
    virtual void                on_adopt          (Command_1 <Model&> *adoptee,
                                                   bool on = true) =0;
    virtual void                on_orphan         (Command_1 <Model&> *adoptee,
                                                   bool on = true) =0;
    virtual void                adopt  (Model * adoptee) =0;
    virtual Model *             orphan (int i) =0;
    virtual Model *             orphan (Model & model) =0;
};

}//MM

#endif //PROJECT_H
