#ifndef PROJECT_IMPL_H
#define PROJECT_IMPL_H

#include "Project.h"
#include "Model.h"
#include "Array_of_own.h"
#include "Event.h"
#include "Project_kit.h"

namespace MM
{

class Project_impl : public Project
{
    Project_kit                     kit_;

    Array_of_own <Model>            model_;
    mutable Model                   *current_model_;

    Event_1 <Model &>               change_current_event_;
    Event_1 <Model &>               adopt_event_;
    Event_1 <Model &>               orphan_event_;

public:
    Project_impl ();
   ~Project_impl ()                     { }

    Project_kit &       kit ()                              {return kit_;}
    Project_kit const & kit () const                        {return kit_;}

    Model &             model (int i);
    const Model &       model (int i) const;
    int                 model_count   () const;

    Model &             current_model ();
    const Model &       current_model () const;
    void                set_current_model (Model &);

    void                on_change_current(Command_1 <Model&> *adoptee, bool on);
    void                on_adopt         (Command_1 <Model&> *adoptee, bool on);
    void                on_orphan        (Command_1 <Model&> *adoptee, bool on);

    void                adopt   (Model * adoptee);
    Model *             orphan  (int i);
    Model *             orphan  (Model & model);

private:
    Project_impl (Project_impl&);
    void operator = (Project_impl&);

    void                set_current_model (Model *);

    virtual bool invariant() const
    {
        bool result = true;
        
        result &= (current_model_ != 0);
        
        result &= current_model_ == &Model::none() 
            ? model_.size() == 0 
            : model_.size() > 0;

        return result;
    }
};

}//MM

#endif //PROJECT_IMPL_H
