#include "Project_kit.h"

#include "Project.h"
#include "Measure_geometry_impl.h"
#include "Protocol_impl.h"
//#include "Form_protocol.h"

namespace MM
{
Project_kit::
Project_kit ()
:
    measure_geometry_(new Measure_geometry_impl)
   ,protocol_        (new Protocol_impl (""))
{
    protocol_list_.adopt (protocol_);
}

void Project_kit::
load_protocol (Text const& file)
{
    Model * model = 0;
    if (Project::singleton().model_count() == 0)
        model = &Model::none();
    else
        model = &Project::singleton().current_model();

    for (int i=0;  i<protocol_list_.size();  ++i)
    {
        if (protocol_list_[i].from_file() == file)
        {
            protocol_ = &protocol_list_[i];
            protocol_->set_model (*model);
            //protocol_->cursor().update();
            return;
        }
    }

    protocol_ = new Protocol_impl (file);
    protocol_->load (file);
    protocol_->set_model (*model);
    protocol_list_.adopt (protocol_);
}

}//MM

