#ifndef PROJECT_KIT_H
#define PROJECT_KIT_H

#ifndef OWN_H
#include "Own.h"
#endif

#ifndef ARRAY_H
#include "Array.h"
#endif

#ifndef ARRAY_OF_OWN_H
#include "Array_of_own.h"
#endif

#ifndef MEASURE_GEOMETRY_H
#include "Measure_geometry.h"
#endif

#ifndef PROTOCOL_H
#include "Protocol.h"
class Monitor;
#endif

#ifndef MONITOR_H
#include "Monitor.h"
#endif

//#include "linked_ptr.h"

namespace MM
{

class Project_kit
{
    Own <Measure_geometry>          measure_geometry_;

    Protocol*                       protocol_;
    Array_of_own <Protocol>         protocol_list_;

//    Array <linked_ptr <Monitor> >   monitor_;
    Array_of_own <Monitor>          monitor_;

public:
    explicit                Project_kit ();

    Measure_geometry &      measure_geometry () {return measure_geometry_();}

    Protocol &              protocol      ()    {return *protocol_;}
    void                    load_protocol (Text const& file);

    Monitor &               monitor (int i)         {return monitor_[i];}
    Monitor const &         monitor (int i)  const  {return monitor_[i];}
    int                     monitor_count () const  {return monitor_.size();}
    Monitor &               adopt  (Monitor *m)     {monitor_.adopt (m); return *m;}
    Monitor &               orphan (Monitor &m)     {monitor_.orphan(m); return m;}
};

}//MM

#endif //PROJECT_KIT_H
