#ifndef PROTOCOL_H
#define PROTOCOL_H

namespace MM
{
class Text;

class Model;
class Model_proxy;

class Protocol_stage;
class Protocol_cursor;
class Protocol_view;

class Protocol
{
public:
    virtual                         ~Protocol () {}

    virtual Text const&             from_file () const      =0;

    virtual Model_proxy &           model     ()        =0;
    virtual void                    set_model (Model &) =0;

    virtual Protocol_stage &        stage (int i)       =0;
    virtual Protocol_stage const &  stage (int i) const =0;
    virtual int                     stage_count() const =0;

    //virtual Protocol_history const& history () const    =0;

    virtual Protocol_cursor &       cursor ()           =0;
    virtual Protocol_cursor const & cursor () const     =0;

    virtual Protocol_view &         view ()             =0;
    virtual Protocol_view const &   view () const       =0;

    virtual void                    load (Text const& filename) =0;
    //virtual void                    save (Text const& filename) const =0;
};

}//MM

#endif //PROTOCOL_H
