#ifndef PROTOCOL_CURSOR_H
#define PROTOCOL_CURSOR_H

#ifndef PROTOCOL_H
#include "Protocol.h"
#endif

#ifndef PROTOCOL_VIEW_H 
#include "Protocol_view.h"
#endif

#ifndef PROTOCOL_STEP_H 
#include "Protocol_stage.h"
#endif

#ifndef DBC_H 
#include "DbC.h"
#endif

namespace MM
{

    class Protocol_cursor : protected DbC
{
    Protocol &              protocol_;
    int                     index_;

public:
    Protocol_cursor (Protocol & protocol) : protocol_(protocol), index_(0) {;}

    void                    first    ()                                         {REQUIRE ("", is_valid()); index_ = 0; update ();}
    void                    next     ()                                         {REQUIRE ("", is_valid()); ++index_; update ();}
    void                    set      (int i)                                    {index_ = i; update (); ENSURE ("", is_valid());}
    bool                    is_valid () const                                   {return index_<protocol_.stage_count();}
    Protocol_stage &        current  ()                                         {REQUIRE ("", is_valid()); return protocol_.stage (index_);}
    Protocol_stage const&   current  () const                                   {REQUIRE ("", is_valid()); return protocol_.stage (index_);}
    int                     index    () const                                   {return index_;}

//private:
    void                    update ()
    {
        protocol_.view().cursor_moved (index_);
        if (is_valid())
            current().update();
    }
};

}//MM

#endif //PROTOCOL_CURSOR_H
