#ifndef PROTOCOL_IMPL_H
#define PROTOCOL_IMPL_H

#ifndef PROTOCOL_H
#include "Protocol.h"
#endif

#ifndef ARRAY_OF_OWN_H
#include "Array_of_own.h"
#endif

#ifndef PROTOCOL_STAGE_H
#include "Protocol_stage.h"
#endif

#ifndef MODEL_PROXY_H
#include "Model_proxy.h"
#endif

#ifndef PROTOCOL_CURSOR_H
#include "Protocol_cursor.h"
#endif

#ifndef PROTOCOL_HISTORY_H
#include "Protocol_cursor.h"
#endif

#ifndef DbC_H
#include "DbC.h"
#endif

namespace MM
{
class Model;

class Protocol_impl : public Protocol, protected DbC
{
    Text                                    file_;
    Array_of_own <Protocol_stage>           stage_;
    Protocol_view &                         view_;
    Protocol_cursor                         cursor_;
//    Protocol_history                        history_;
    Model_proxy                             model_;
    Model *                                 model_tmp_;

public:
    explicit                        Protocol_impl (Text const& file);

    virtual Text const &            from_file () const      {return file_;}

    virtual Model_proxy &           model     ();
    virtual void                    set_model (Model & model);

    virtual Protocol_stage &        stage (int i)       {return stage_[i];}
    virtual Protocol_stage const &  stage (int i) const {return stage_[i];}
    virtual int                     stage_count() const {return stage_.size();}
    //virtual Protocol_stage &        last  (int i)       =0;
    //virtual Protocol_stage const &  last  (int i) const =0;

    virtual Protocol_cursor &       cursor ()           {return cursor_;}
    virtual Protocol_cursor const & cursor () const     {return cursor_;}

    virtual Protocol_view &         view ()             {return view_;}
    virtual Protocol_view const &   view () const       {return view_;}

    void                            load (Text const& filename);
    //void                            save (Text const& filename){}
protected:
    bool                            invariant () const;
};

}//MM

#endif //PROTOCOL_IMPL_H
