#include "Protocol_stage.h"

#include <sstream>

#include "Flaw.h"
#include "DbC.h"

#include "Optimization_stage.h"
#include "Simulation_stage.h"
#include "Pause_stage.h"
#include "Initialization_stage.h"

#include "Protocol.h"
#include "Project.h"
#include "Project_kit.h"
#include "Intention.h"

namespace MM
{

Protocol_stage * Protocol_stage::
create (Text const& init)
{
    using namespace std;
    
    Protocol & protocol = Project::singleton().kit().protocol();

    istringstream in (init.c_str());
    string        intention_name;
    in >> intention_name;

    Protocol_stage * stage;

    if (intention_name == "Setup_initial_conditions" ||//fix remove
        intention_name == "Equilibration"            ||
        intention_name == "Production"               ||
        intention_name == "Heating"                  ||
        intention_name == "Cooling"                    )
    {
        stage = new Simulation_stage (protocol, init);
    }
    else if (intention_name == "Optimization")
    {
        stage = new Optimization_stage (protocol, init);
    }
    else if (intention_name == "Initial_conditions")
    {
        stage = new Initialization_stage (protocol, init);
    }
    else if (intention_name == "Pause")
    {
        stage = new Pause_stage (protocol, init);
    }
    /*else if (intention_name == "")
    {
        stage = new (protocol, init);
    }//*/
    else
        FLAW (Text("'") + intention_name.c_str() +"' - unexpected intention.");

    Intention * intention = Intention::create (intention_name.c_str(), *stage);
    Text intention_title = intention->title ();
    //fix
    //CONTRACT CHECK ("", intention_title == intention_name.c_str());
    stage->set_intention (intention);
    
    return stage;
}

Protocol_stage::~Protocol_stage () {}

}//MM


