#ifndef PROTOCOL_STAGE_H
#define PROTOCOL_STAGE_H

#ifndef TEXT_H
#include "Text.h"
class Monitor;
#endif

namespace MM
{
class Intention;
class Protocol_step_view;
class Monitor;
class Command;

class Protocol_stage
{
public:
    static Protocol_stage *  create (Text const& init);
    virtual                 ~Protocol_stage ();

    virtual void            execute () =0;
    virtual void            stop    () =0;
    virtual void            tune    () =0;
    virtual void            start   () =0;
    virtual void            at_every_iteration (Command *adoptee) =0;

    //virtual Text            title () const =0;

    virtual Intention &     intention() =0;
    virtual void            set_intention (Intention * adoptee) =0;

    virtual Text            option     (Text const & key) const =0;
    virtual void            set_option (Text const& key, Text const& value) =0;

    virtual void            get_option (int i, Text &key, Text &value) const =0;
    virtual int             option_count () const =0;

    virtual Monitor &       monitor (int i)        =0;
    virtual Monitor const & monitor (int i)  const =0;
    virtual int             monitor_count () const =0;

    virtual void            update () =0;
    virtual void            edit   () =0;

    //virtual Protocol_step_view &        view () =0;
    //virtual Protocol_step_view const &  view () const =0;


//    void                    get_option (int i, Text & key, Text & value);
//    void                    set_option (int i, Text const& key,
//                                               Text const& value);
};

}//MM

#endif //PROTOCOL_STAGE_H
