#ifndef PROTOCOL_STAGE_FRAME_H
#define PROTOCOL_STAGE_FRAME_H

#ifndef PROTOCOL_STAGE_H
#include "Protocol_stage.h"
#endif

#ifndef INTENTION_H
#include "Intention.h"
#endif

#ifndef DURATION_UNIT_H
#include "Duration_unit.h"
#endif

#ifndef COMMAND_H
#include "Command.h"
#endif

#ifndef OWN_H
#include "Own.h"
#endif

#if defined WIN32
#pragma warning(disable: 4355)
#endif


namespace MM
{
class Protocol;

class Protocol_stage_frame : public Protocol_stage
{
protected:
    Protocol &              protocol_;
    Duration_unit           length_;
    Own <Intention>         intention_;
    Text                    comment_;

public:
    explicit Protocol_stage_frame (Protocol & protocol)
    :
        protocol_   (protocol),
        intention_  (Intention::none (*this))
//        intention_  ((Intention*)123)
    {
    }

    void                    tune    ()                                          {;}
    void                    start   ()                                          {execute ();}

    //Text                    title () const                                      {return intention_().title ();}

    Intention &             intention()                                         {return intention_();}
    void                    set_intention (Intention * adoptee)                 {intention_.adopt(adoptee);}
};

}//MM

#endif //PROTOCOL_STAGE_FRAME_H
