#ifndef BAROSTAT_H
#define BAROSTAT_H

#ifndef PRESSURE_H
#include "Pressure.h"
#endif

namespace MM
{
//class Pressure_unit;
class Model;
class MD;

class Barostat
{
protected:
    Model &         model_;
    MD &            MD_simulation_;
    Pressure        pressure_;
    double          desired_pressure_;
    bool            turn_flag_;

public:
   explicit  Barostat (Model & model, MD & simulation);
    virtual         ~Barostat ();

    static Barostat & none ();

    bool            is_on  () const                                             {return  turn_flag_;}
    bool            is_off () const                                             {return !turn_flag_;}
    void            turn (bool on)                                              {turn_flag_ = on;}

    virtual char const* title () const =0;

    virtual void    execute ()                                                  {if (is_on()) handle_execute ();}
    virtual void    handle_execute () =0;

    virtual double  calc_pressure () const                                      {return pressure_.value();}
    
    virtual double  desired_pressure () const                                   {return desired_pressure_;}
    virtual void    set_desired_pressure (double v)                             {desired_pressure_ = v;}
};

}//MM

#endif //BAROSTAT_H
