#ifndef CLASSIC_EULER_H
#define CLASSIC_EULER_H

#ifndef EULER_H
#include "Euler.h"
#endif

#ifndef LOCK_H
#include "Lock.h"
#endif  

namespace MM
{

class Classic_Euler : public Euler
{
    int     update_list_;
    double  skin_;

public:
    explicit Classic_Euler (Prototype const &) {adopt_prototype (this);}
    explicit Classic_Euler () :   update_list_(4), skin_(.5) { }
    char const* class_name () const {return "Classic_Euler";}
    char const* title      () const {return "Classic Euler";}
    char const* alias      () const {return "Euler";}
    MD_method * clone () const      {return new Classic_Euler;}

protected:
    virtual void start ()
    {
        Lock<MD> lock(simulation());
        MD_method::start ();
        step_N_ = 0;
        list (MD_subject::Whole, skin_);
        F ();
    }
    virtual void        step   ()
    {
        Lock<MD> lock(simulation());

        if (step_N_ % update_list_ == 0)
            list (MD_subject::Whole, skin_);

        F ();
        drift (1.);
        kick  (1.);

        ++step_N_;
    }
};

}//MM

#endif //CLASSIC_EULER_H
