#ifndef MC_H
#define MC_H

#ifndef SIMULATION_H
#include "Simulation.h"
#endif

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef MD_SUBJECT_H
#include "MD_subject.h"
#endif

#ifndef MC_METHOD_H
#include "MC_method.h"
#endif

#ifndef EVENT_H
#include "Event.h"
#endif

#ifndef OWN_H
#include "Own.h"
#endif

namespace MM
{
class MC : public Simulation
{
    Own <MD_subject>                    subject_;
    Own <MC_method>                     method_;
//    Barostat *                          barostat_;

    Event                               step_finished_;
    Event                               stop_;
    bool                                stop_flag_;

public:
    char const *    class_name () const {return "MC";}
    void            stop ()             {stop_flag_ = true;}
    Text            title      () const;

    void            start      ();
    void            cycle      () =0;
    int             iterations () const =0;
    void            finish     ();
};

}//MM

#endif //MC_H
