#ifndef MC_SIMULATOR_H
#define MC_SIMULATOR_H

#ifndef SIMULATOR_FRAME_H
#include "Simulator_frame.h"
#endif

#ifndef DURATION_UNIT_H
#include "Duration_unit.h"
#endif

#include "Flaw.h"

namespace MM
{
class Prototype;

class MC_simulator : public Simulator_frame
{
    Duration_unit                       length_;

    static MC_simulator                 prototype_;

public:
    MC_simulator (Prototype &);
    MC_simulator ();
    Simulator *     clone () const;

    bool                is_running () const {FIX; return 0;}
    void                stop () {FIX;}

    void                tune  () {FIX;}
    void                handle_start () {FIX;}

    void                edit_options (){;}//fix

    Text const&         title () const                                          {static Text r="MC"; return r;}

    void                add_comment (Text const &){}

    bool                    support_duration () const                           {return false;}
    //double                  step_length () const                                {return 0;}
    //void                    set_step_length (double )
    Duration_unit           duration () const       {return Duration_unit();}
    void                    set_duration (Duration_unit l)       {FIX;}

    int                     steps     () const                                  {return (int)length_.steps ();}
    void                    set_steps (int steps)                               {length_.set_steps (steps);}

    double          desired_pressure () const                                   {FIX;}
    void            set_desired_pressure (double)                               {FIX;}

    bool                    support_temperature      () const                   {return true;}
//    void                    setup_new_temperature    (double v)               {FIX;}
//    void                    set_starting_temperature (double v)               {FIX;}//fix
//    void                    set_starting_pressure    (double v)               {FIX;}//fix
//    void                    set_final_temperature    (double v)               {FIX;}
//    void                    set_final_pressure       (double v)               {FIX;}
    void                    setup_velocities         (Temperature_unit const& ) {FIX;}
    Temperature_unit        desired_temperature () const                        {FIX; return Temperature_unit();}
    void                    set_desired_temperature (Temperature_unit const& ) {FIX;}//fix
//    void                    set_starting_pressure    (double )                  {FIX;}//fix
//    void                    set_final_temperature    (Temperature_unit const& ) {FIX;}
//    void                    set_final_pressure       (double )                  {FIX;}
    bool                    support_thermostat       () const                   {return true;}
    bool                    support_barostat         () const                   {return true;}
    bool                    has_thermostat           () const                   {return false;}
    bool                    has_barostat             () const                   {return false;}
//    void                    set_thermostat (bool on)                          {FIX;}
//    void                    set_barostat   (bool on)                          {FIX;}
    void                    set_thermostat (bool )                              {FIX;}
    void                    set_barostat   (bool )                              {FIX;}

//    void                    add_monitor (char const * name)                   {FIX;}

//    void                    after_each_step           (Command * to_do)       {FIX;}
//    void                    after_stop                (Command * to_do)       {FIX;}
//    void                    eliminate_after_each_step (Command & to_do)       {FIX;}
//    void                    eliminate_after_stop      (Command & to_do)       {FIX;}

    void                    add_monitor (char const * )                         {FIX;}

    void                    after_each_step           (Command * )              {FIX;}
    void                    after_stop                (Command * )              {FIX;}
    void                    eliminate_after_each_step (Command & )              {FIX;}
    void                    eliminate_after_stop      (Command & )              {FIX;}

    void                    update ()                                           {FIX;}
};

}//MM

#endif //MC_SIMULATOR_H
