#ifndef MD_SIMULATOR_H
#define MD_SIMULATOR_H

#ifndef SIMULATOR_FRAME_H
#include "Simulator_frame.h"
#endif

namespace MM
{
class Barostat;
class Thermostat;
class MD_method;
class MD_subject;

class MD_simulator : public Simulator_frame
{
public:
    explicit MD_simulator (Model & model) : Simulator_frame(model) { }
    explicit MD_simulator (){}

    virtual void                    publish_step_finished () =0;

    //static MD_simulator &   current ();
    //static void             adopt (MD_simulator * );

    virtual MD_method &             method () =0;
    virtual char const *            method_name () const =0;
    virtual void                    set_method (char const * name) =0;

    virtual MD_subject &            subject () =0;

    virtual Barostat &              barostat ()       =0;
    virtual Barostat const&         barostat () const =0;

    virtual Thermostat &            thermostat ()       =0;
    virtual Thermostat const&       thermostat () const =0;
    virtual void                    set_thermostat (char const * name) =0;
};

}//MM
#endif //MD_SIMULATOR_H
