#ifndef MD_SUBJECT_H
#define MD_SUBJECT_H

namespace MM
{
class Temperature_unit;

class MD_subject
{
    static bool         to_cut_large_forces_;

public:
    explicit MD_subject ()/* : to_cut_large_forces_(true)*/ {}
    virtual ~MD_subject () ;

    enum Hint {Short, Long,  Long1,  Long2,  Long3, Whole};

    virtual void        start   () =0;
    virtual void        finish  () =0;

    virtual void        zero_virial () =0;
    virtual double      degrees_of_freedom () =0;
    virtual double      H () =0;
    virtual double      K () =0;
    virtual double      U () =0;
    virtual void        list    (Hint hint, double skin) =0;
    virtual void        list    (Hint hint, double R, double skin) =0;
    virtual void        F       (Hint hint = Whole) =0;
    virtual void        F       (Hint hint, double R, double Switching) =0;
    virtual void        clear_moment (Hint hint) =0;
    virtual void        kick    (double dT, Hint hint = Whole) =0;
    virtual void        kick    (int substeps, double dT, Hint hint = Whole) =0;
    virtual void        drift   (double dT) =0;
    virtual void        keep_configuration () =0;
    virtual void        restore_configuration () =0;
    virtual void        update  (bool force = false) =0;
    virtual bool        locked () const =0;
    virtual void        set_lock (bool on) =0;
    virtual void        setup_velocities (Temperature_unit const& t) =0;

    static bool         to_cut_large_forces  () /*const*/   {return to_cut_large_forces_;}
    static void         set_cut_large_forces (bool on)  {to_cut_large_forces_ = on;}
};

}//MM

#endif //MD_SUBJECT_H
