#ifndef MTS_H
#define MTS_H

#ifndef MD_METHOD_H
#include "MD_method.h"
#endif

#ifndef MD_H
#include "MD.h"
#endif

namespace MM
{

class MTS : public MD_method
{
protected:
    int             inner_steps_;
    double          S_;      // Switch A

    double          R_;

public:
    MTS () : inner_steps_(20), S_(3.5), R_(6.) {}

    int         inner_steps ()  const       {return inner_steps_;}
    void        set_inner_steps (int v)     {inner_steps_= v;}

    double      Switch ()  const            {return S_;}
    void        set_Switch (double v)       {S_= v;}

    double      R ()  const                 {return R_;}
    void        set_R (double v)            {R_= v;}
};

}//MM

#endif //MTS_H
