#ifndef MTS_VP_H
#define MTS_VP_H

#ifndef MTS_H
#include "MTS.h"
#endif

#ifndef MD_H
#include "MD.h"
#endif

namespace MM
{

class MTS_VP : public MTS
{
    //int     update_list_;
    //double  R_;
    //double  skin_;

public:
    explicit MTS_VP (Prototype const &) {adopt_prototype (this);}
    explicit MTS_VP ()
    //:   update_list_(4), R_(6), skin_(.5)
    {inner_steps_ = 10;}

    virtual void adopt_inner_step (){}

protected:
    /*virtual Text const& method () const
    {
        static const Text name = MD::method() 
            + ": Multiple time step";
        return name;
    }//*/

    char const*     class_name () const {return "MTS_VP";}
    char const*     title      () const {return "Multiple time step V.P.";}
    char const*     alias      () const {return "MTS VP";}

    MD_method *     clone () const      {return new MTS_VP;}

    virtual void start ()
    {
        Lock<MD> lock(simulation());
        MD_method::start ();
        step_N_ = 0;

        list (MD_subject::Long, skin_); 
        list (MD_subject::Short, R_, skin_);

        F (MD_subject::Long);
        F (MD_subject::Long1,  R_, S_);
        F (MD_subject::Short);
    }


	virtual void step ()
    {
        Lock<MD> lock(simulation());
        int last_step = inner_steps_-1;

        kick (.5, MD_subject::Long);

        simulation_->algorithm().description ("{");

        for (int i=0;  i<inner_steps_;  ++i)
        {
            drift (.5 / inner_steps_);
            F (MD_subject::Long1, R_, S_);
            F (MD_subject::Short);
            kick  (1. / inner_steps_, MD_subject::Long1);
            kick  (1. / inner_steps_, MD_subject::Short);
            drift (.5 / inner_steps_);

            if (i<last_step)
                simulation_->algorithm().description ("");
        }

        simulation_->algorithm().description ("}");

        if (step_N_ % update_list_ == 0)
        {
            list (MD_subject::Long,  skin_);
            list (MD_subject::Short, R_, skin_); 
        }

        zero_virial();

        F (MD_subject::Long);
        F (MD_subject::Long1, R_, S_);
        F (MD_subject::Short); 
        //F (MD_subject::Whole);
        kick (.5, MD_subject::Long);

        ++step_N_;
    }
};

}//MM

#endif //MTS_VP_H
