#include "Mass.h"

#include "Atom.h"
#include "Atom_group.h"
#include "Element.h"

namespace MM
{
double Mass::minimal_ = 10.;
bool   Mass::has_minimal_ = true;

Mass::
Mass (Atom_group const & group)
:
    group_(group)
{
    for (int i=0;  i<group_.atom_count(); ++i)
    {
        double mass = group_.atom(i).mass ();
        if (has_minimal_ && mass < minimal())
            mass = minimal();
        double inv_mass = 1. / mass;
        inv_mass_.push_back (inv_mass);
        //inv_mass_.push_back (inv_mass);
        //inv_mass_.push_back (inv_mass);
    }
}


int Mass::
size () const
{
    return inv_mass_.size();
}

}//MM

