#ifndef MASS_H
#define MASS_H

#ifndef ARRAY_H
#include "Array.h"
#endif

namespace MM
{
class Atom_group;

class Mass
{
    static double           minimal_;
    static bool             has_minimal_;

    Atom_group const &      group_;
    Array <double>          inv_mass_;

public:
    explicit Mass (Atom_group const & group);
    virtual ~Mass () {}

    static bool             has_minimal ()              {return has_minimal_;}
    static void             set_has_minimal (bool on)   {has_minimal_ = on;}
    static double           minimal ()                  {return minimal_;}
    static void             set_minimal (double v)      {minimal_ = v;}

    virtual int             size () const ;
    double                  inverse (int i) const {return inv_mass_[i];}
};

}//MM

#endif //MASS_H
