#ifndef OPVL_H
#define OPVL_H

#ifndef OVL_H
#include "OVL.h"
#endif

#ifndef LOCK_H
#include "Lock.h"
#endif  

namespace MM
{
                                                                         
class OPVL : public OVL 
{
    int     update_list_;
    double  skin_;

public:
    explicit OPVL (Prototype const &) {adopt_prototype (this);}
    explicit OPVL () :   update_list_(2), skin_(.5) { }
    //explicit OPVL (MD_subject & subject) : OVL (subject) { }
    char const* class_name () const {return "OPVL";}
    char const* title      () const {return "Optimized Position Verlet-Like";}
    char const* alias      () const {return "OPVL";}
    MD_method * clone () const      {return new OPVL;}

protected:
    virtual void start ()
    {
        Lock<MD> lock(simulation());
        MD_method::start ();
        step_N_ = 0;
        list (MD_subject::Whole, skin_);
        F ();
    }

    virtual void        step   ()
    {
        Lock<MD> lock(simulation());

        drift (xi());

        if (step_N_ % update_list_ == 0)
            list (MD_subject::Whole, skin_);

        F ();
        kick  (0.5);

        drift (1.-2.*xi());

        F ();
        kick  (0.5);

        drift (xi());

        ++step_N_;
    }
};

}//MM

#endif //OPVL_H
