#ifndef OVL_H
#define OVL_H

#ifndef MD_H
#include "MD.h"
#endif

#include <math.h>

#ifndef MD_METHOD_H
#include "MD_method.h"
#endif

namespace MM
{

// Omelyan I.P., Mryglod I.M., Folk R.
// New optimized algorithms for molecular dynamics simulations.
// Condensed Matter Physics. 2002. V.5. No.3(31). pp.369-390

class OVL : public MD_method
{
public:
    //OVL (MD_subject & subject) : MD_method (subject) { }

    virtual double xi    () const
    {
        #ifndef NDEBUG
        double Xi, a;
        a = pow (2* sqrt (326.) + 36., 1./3.);
        Xi = 0.5 - a/12. + 1/(6*a);
        ENSURE ("", fabs(0.1931833275037836 - Xi) 
                       < 0.0000000000000001);
        #endif

        return 0.1931833275037836;
    };

};

}//MM

#endif //OVL_H
