#ifndef OVVL_H
#define OVVL_H

#ifndef OVL_H
#include "OVL.h"
#endif

#ifndef LOCK_H
#include "Lock.h"
#endif  

namespace MM
{

class OVVL : public OVL
{
    int     update_list_;
    double  skin_;

public:
    explicit OVVL (Prototype const &) {adopt_prototype (this);}
    explicit OVVL () :   update_list_(2), skin_(.5)  { }
    //explicit OVVL (MD_subject & subject) : OVL (subject) { }
    char const* class_name () const {return "OVVL";}
    char const* title      () const {return "Optimized Velocity Verlet-Like";}
    char const* alias      () const {return "OVVL";}
    MD_method * clone () const      {return new OVVL;}

protected:
    virtual void start ()
    {
        Lock<MD> lock(simulation());
        MD_method::start ();
        step_N_ = 0;
        list (MD_subject::Whole, skin_);
        F ();
    }

    virtual void        step   ()
    {
        Lock<MD> lock(simulation());

        if (step_N_ % update_list_ == 0)
            list (MD_subject::Whole, skin_);

        kick  (xi());
        drift (0.5);
        F ();
        kick  (1.-2.*xi());
        drift (0.5);
        F ();
        kick  (xi());

        ++step_N_;
    }
};

}//MM

#endif //OVVL_H
