#ifndef PEFRL_H
#define PEFRL_H

#ifndef EFRL_H
#include "EFRL.h"
#endif

#ifndef LOCK_H
#include "Lock.h"
#endif  

namespace MM
{

class PEFRL : public EFRL // Position Extended Forest-Ruth-Like
{
    int     update_list_;
    double  skin_;

public:
    explicit PEFRL (Prototype const &) {adopt_prototype (this);}
    explicit PEFRL () :   update_list_(1), skin_(.5) { }
    //explicit PEFRL (MD_subject & subject) : EFRL (subject) { }
    char const* class_name () const {return "PEFRL";}
    char const* title      () const {return "Position Extended Forest-Ruth-Like";}
    char const* alias      () const {return "PEFRL";}
    MD_method * clone () const      {return new PEFRL;}

protected:
    double  xi    () const {return  0.1786178958448091;}
    double  lambda() const {return -0.2123418310626054;}
    double  chi   () const {return -0.06626458266981849;}

    virtual void start ()
    {
        Lock<MD> lock(simulation());
        MD_method::start ();
        step_N_ = 0;
        list (MD_subject::Whole, skin_);
        F ();
    }

    virtual void        step   ()
    {
        Lock<MD> lock(simulation());

        drift (xi());

        if (step_N_ % update_list_ == 0)
            list (MD_subject::Whole, skin_);

        F ();
        kick  ((1.-2.*lambda())/2.);
        drift (chi());
        F ();
        kick  (lambda());
        drift (1.-2.*(chi()+xi()));
        F ();
        kick  (lambda());
        drift (chi());
        F ();
        kick  ((1.-2.*lambda())/2.);
        drift (xi());

        ++step_N_;
    }
};

}//MM

#endif //PEFRL_H
