#ifndef POSITION_LEAPFROG_H
#define POSITION_LEAPFROG_H

#ifndef LEAPFROG_H
#include "Leapfrog.h"
#endif

#ifndef LOCK_H
#include "Lock.h"
#endif  

namespace MM
{
 
class Position_leapfrog : public Leapfrog
{
    int     update_list_;
    double  skin_;

public:
    explicit Position_leapfrog (Prototype const &) {adopt_prototype (this);}
    explicit Position_leapfrog () :   update_list_(4), skin_(.5) { }
    //explicit Position_leapfrog (MD_subject & subject) : Leapfrog (subject) { }
    char const* class_name () const {return "Position_leapfrog";}
    char const* title      () const {return "Position leapfrog";}
    char const* alias      () const {return "Position leapfrog";}
    MD_method * clone () const      {return new Position_leapfrog;}

protected:
    virtual int         iterations () const {return simulation().steps()-1;}

    virtual void        start  ()
    {
        Lock<MD> lock(simulation());
        MD_method::start ();
        step_N_ = 0;
        list (MD_subject::Whole, skin_);
        drift (.5);
    }
    virtual void        step   ()
    {
        Lock<MD> lock(simulation());

        if (step_N_ % update_list_ == 0)
            list (MD_subject::Whole, skin_);

        F ();
        kick  (1.);
        drift (1.);

        ++step_N_;
    }
    virtual void        finish ()
    {
        Lock<MD> lock(simulation());
        F ();
        kick  (1.);
        drift (.5);
        MD_method::finish ();
    }
};

}//MM

#endif //POSITION_LEAPFROG_H
