#ifndef POSITION_VERLET_H
#define POSITION_VERLET_H

#ifndef LEAPFROG_H
#include "Leapfrog.h"
#endif

#ifndef LOCK_H
#include "Lock.h"
#endif  

namespace MM
{

class Position_verlet : public Leapfrog
{
    int     update_list_;
    double  skin_;

public:
    explicit Position_verlet (Prototype const &) {adopt_prototype (this);}
    explicit Position_verlet () :   update_list_(4), skin_(.5) { }
    //explicit Position_verlet (MD_subject & subject) : Leapfrog (subject) { }
    char const* class_name () const {return "Position_verlet";}
    char const* title      () const {return "Position Verlet";}
    char const* alias      () const {return "Position Verlet";}
    MD_method * clone () const      {return new Position_verlet;}

protected:
    virtual void start ()
    {
        Lock<MD> lock(simulation());
        MD_method::start ();
        step_N_ = 0;
        list (MD_subject::Whole, skin_);
        F ();
    }

    virtual void        step   ()
    {
        Lock<MD> lock(simulation());

        drift (.5);

        if (step_N_ % update_list_ == 0)
            list (MD_subject::Whole, skin_);

        F ();
        kick  (1.);
        drift (.5);

        ++step_N_;
    }
};

}//MM

#endif //POSITION_VERLET_H
