#include "Simulation.h"

#include "Path.h"

namespace MM
{

void Simulation::
run ()
{
    running_flag_ = true;
    algorithm().description ("Simulation start.");
    if (iterations() >= 0)
    {
        try
        {
            start  ();
            cycle  ();
            finish ();
        }
        catch(...)
        {
            running_flag_ = false;
            throw;
        }
    }
    algorithm().description ("Simulation finish.");
    running_flag_ = false;
}

Simulation::
Simulation ()
:
    steps_(1000000),
    running_flag_(false)
{
    describer_.write_in_file (Path::report() + "algorithm.log");
}

}//MM
