#ifndef SIMULATION_H
#define SIMULATION_H

#ifndef COMMAND_H
#include "Command.h"
#endif

#ifndef CALCULATION_H
#include "Calculation.h"
#endif

#ifndef DESCRIBER_H
#include "Describer.h"
#endif

#ifndef OWN_H
#include "Own.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

namespace MM
{

class Simulation : public Calculation, public Command, protected DbC
{
protected:
    Describer                   describer_;
    int                         steps_;
    bool                        running_flag_;

public:
    explicit Simulation ();

    virtual char const *    class_name () const =0;
    Describer &             algorithm ()            {return describer_;}
    //virtual char const *    algorithm_name () const =0;

    // Command interface
    void                    execute () {run();}

    virtual bool            is_running () const     {return running_flag_;}
    void                    run ();
    int                     steps     () const      {return steps_;}
    void                    set_steps (int steps)   {steps_ = steps;}
    
    virtual void            stop () =0;
    virtual void            publish_step_finished () {}

protected:
    virtual Text            title      () const =0;
    virtual void            start      () =0;
    virtual void            cycle      () =0;
    //virtual void            step       () =0;
    virtual int             iterations () const =0;
    virtual void            finish     () =0;
};

}//MM

#endif //SIMULATION_H
