#ifndef SIMULATION_STAGE_H
#define SIMULATION_STAGE_H

#ifndef PROTOCOL_STAGE_FRAME_H
#include "Protocol_stage_frame.h"
#endif

#ifndef FLAW_H
#include "Flaw.h"
#endif

#ifndef TEMPERATURE_UNIT_H
#include "Temperature_unit.h"
#endif

#ifndef PRESSURE_UNIT_H
#include "Pressure_unit.h"
#endif

#ifndef SIMULATOR_H
#include "Simulator.h"
#endif

#ifndef MONITOR_H
#include "Monitor.h"
#endif

#ifndef MONITOR_FRAME_H
#include "Monitor_frame.h"//fix remove
#endif

#ifndef OWN_H
#include "Own.h"
#endif

namespace MM
{

class Simulation_stage : public Protocol_stage_frame
{
    Temperature_unit        temperature_;
    Pressure_unit           pressure_;
    Own <Simulator>         simulator_;

public:        
    explicit        Simulation_stage (Protocol &protocol, Text const & init);

    void            execute ();
    void            stop    ();
    void            tune    ();
    void            start   ();

    void            at_every_iteration (Command *adoptee);

    //Text            title () const;
    virtual Text    option     (Text const & key) const;
    virtual void    set_option (Text const & key, Text const & value);
    virtual void    get_option (int i, Text & key, Text & value) const;
    virtual int     option_count () const {return 5;}

    Monitor &       monitor (int i)       {return simulator_().monitor (i);}
    Monitor const & monitor (int i) const {return simulator_().monitor (i);}
    int             monitor_count() const {return simulator_().monitor_count();}

    void            update ();
    void            edit ();
};

}//MM

#endif //SIMULATION_STAGE_H
