#ifndef SIMULATOR_H
#define SIMULATOR_H

#ifndef DURATION_UNIT_H
#include "Duration_unit.h"
#endif

#ifndef TEMPERATURE_UNIT_H
#include "Temperature_unit.h"
#endif

#ifndef PRESSURE_UNIT_H
#include "Pressure_unit.h"
#endif

namespace MM
{
class Model;
class Text;
class Monitor;
class Command;
class Interaction;//fix remove

class Simulator
{
public:
    virtual                 ~Simulator ();
    virtual Simulator *     clone () const =0;

    virtual Model &         model () =0;
    virtual void            set_model (Model &model) =0;

    virtual bool            is_running () const =0;
    virtual void            run  ()             {tune (); start ();}
    virtual void            stop () =0;

    virtual void            tune  () =0;
    virtual void            start () =0;

    virtual void            edit_options () =0;
    virtual void            add_comment (Text const &) =0;

    virtual Text const&     title () const =0;

    virtual bool            support_duration () const =0;
    virtual Duration_unit   duration () const =0;
    virtual void            set_duration (Duration_unit l)=0;

    virtual int             steps     () const =0;
    virtual void            set_steps (int steps) =0;

    virtual bool            support_temperature     () const =0;
    virtual void            setup_velocities        (Temperature_unit const&)=0;
    //virtual void            set_starting_temperature(Temperature_unit const&)=0;
    virtual Temperature_unit desired_temperature () const =0; //fix remove
    virtual void            set_desired_temperature(Temperature_unit const & )=0;

    virtual double          desired_pressure () const =0;
    virtual void            set_desired_pressure (double)=0;

    //virtual void            set_starting_pressure   (double v) =0;
    //virtual void            set_final_temperature   (Temperature_unit const&)=0;
    //virtual void            set_final_pressure      (double v) =0;
    virtual bool            support_thermostat      () const =0;
    virtual bool            support_barostat        () const =0;
    virtual bool            has_thermostat          () const =0;
    virtual bool            has_barostat            () const =0;
    virtual void            set_thermostat          (bool on) =0;
    virtual void            set_barostat            (bool on) =0;

    virtual int             monitor_count () const =0;
    virtual Monitor &       monitor (int n) =0;
    virtual Monitor const & monitor (int n) const =0;
    virtual void            add_monitor (char const * name) =0;
    virtual void            clear_monitors () =0;
    virtual void            after_each_step           (Command * to_do) =0;
    virtual void            after_stop                (Command * to_do) =0;
    virtual void            eliminate_after_each_step (Command & to_do) =0;
    virtual void            eliminate_after_stop      (Command & to_do) =0;

    virtual void            update () =0;

    virtual void            adopt_interaction (Interaction * new_interaction) =0; //fix remove
};

}//MM

#endif //SIMULATOR_H
