#include "Simulator_factory.h"

#include "Simulator.h"
#include "Text.h"
#include "DbC.h"
#include "Create.h"

#ifdef WIN32
#pragma warning(disable : 4786)
#pragma warning(disable : 715)
#endif

#include <map>

namespace
{
    std::map <MM::Text, MM::Simulator*> & map()
    {
        static std::map <MM::Text, MM::Simulator*>   map;
        return map;
    }
}

namespace MM
{

Simulator *  Simulator_factory::
create (Text const& type)
{
    CONTRACT REQUIRE (Text("Prototype of \"") + type + "\" exist",
        map().find(type) != map().end());

    return map().find(type)->second->clone ();
}

void Simulator_factory::
accept (Text const& type, Simulator *simulator)
{
    map()[type] = simulator;
}

int Simulator_factory::
count ()
{
    return map().size();
}

Text const& Simulator_factory::
type (int i)
{
    int j=0;
    for (std::map <Text, Simulator*>::iterator it=map().begin();
         it != map().end();  ++it, ++j)
    {
        if (j == i)
            return it->first;
    }
    return nil <Text>();
}
}//MM
