#ifndef SIMULATOR_FRAME_H
#define SIMULATOR_FRAME_H

#ifndef SIMULATOR_H
#include "Simulator.h"
#endif

#ifndef MONITOR_H
#include "Monitor.h"
#endif

#ifndef ARRAY_OF_REF_H
#include "Array_of_ref.h"
#endif

#ifndef MODEL_PROXY_H
#include "Model_proxy.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

namespace MM
{
class Model;

class Simulator_frame : public Simulator, protected DbC
{
protected:
//    Model *                             model_;
    Model_proxy                         model_;

    Array_of_ref <Monitor>              monitor_;

public:
    //explicit Simulator_frame (Model & model) : model_(&model) { }
    explicit Simulator_frame (Model & model) : model_(model) { }
    explicit Simulator_frame ();

    Model &                 model ();
    virtual void            set_model (Model & model)                           {model_.set_model (&model);}//{model_ = &model;}

    void                    start ();
    virtual void            handle_start () =0;

    int                     monitor_count () const  {return monitor_.size();}
    Monitor const &         monitor (int n) const   {return monitor_[n];}
    Monitor &               monitor (int n)         {return monitor_[n];}
    void                    clear_monitors ();

    //void                after_each_step (Command * to_do) =0;
    //void                unsubscribe (Command & to_do) =0;

    void                    adopt_interaction (Interaction * new_interaction);
};

}//MM

#endif //SIMULATOR_FRAME_H
