#include "Thermostat.h"

#include "No_thermostat.h"
#include "Temperature.h"
#include "Atom_group.h"
#include "Atom.h"
#include "Atom_kit.h"
#include "System_of_Units.h"

namespace MM
{
Thermostat::
Thermostat (Model & model, Atom_group & atom_group, MD & simulation)
:
    model_(model),
    atom_group_(atom_group),
    MD_simulation_(simulation),
    thermostat_flag_(true)
{
    set_desired_temperature (Temperature_unit());
}

Thermostat & Thermostat::
none ()
{
    static No_thermostat instance;
    return instance;
}

double Thermostat::
calc_temperature () const
{
    return calc_temperature (atom_group_);
}

double Thermostat::
calc_temperature (Atom_group const & atom_group) const
{
    Temperature result (atom_group);
    return result.value();

    /*int     count = atom_group.atom_count();
    double  sum = 0.;

    for (int i=0;  i<count;  ++i)
    {
        Atom const & atom = atom_group.atom (i);
        double mass = atom.mass();
        double velocity_2 = atom.kit().velocity().length_2();
        sum += mass * velocity_2;
    }

    //0.001987191 kcal mol-1 K-1 * 4.184  = 0.008 314 51 kJ mol-1 K-1
    double kB = System_of_Units::singleton().gas_constant();

    return  sum / (3. * count * kB); //*/
}

void Thermostat::
set_desired_temperature (Temperature_unit const & t)
{
    T0_ = System_of_Units::singleton().temperature (t);
}

Temperature_unit const& Thermostat::
desired_temperature () const
{
    System_of_Units::singleton().set_temperature (result_, T0_);
    return result_;
}

}//MM
