#ifndef THERMOSTAT_H
#define THERMOSTAT_H

#ifndef TEMPERATURE_UNIT_H
#include "Temperature_unit.h"
#endif

namespace MM
{
class Temperature_unit;
class Model;
class Atom_group;
class MD;

class Thermostat
{
    mutable Temperature_unit    result_;

protected:
    Model      &                model_;
    Atom_group &                atom_group_;
    MD         &                MD_simulation_;
    double                      T0_;                // desired temperature
    bool                        thermostat_flag_;

public:
    explicit            Thermostat (Model &, Atom_group &, MD & );

    virtual             ~Thermostat () { }

    static Thermostat & none ();

    bool                is_on  () const                                         {return  thermostat_flag_;}
    bool                is_off () const                                         {return !thermostat_flag_;}
    void                turn (bool on)                                          {thermostat_flag_ = on;}

    virtual char const* title () const =0;

    virtual void        execute ()                                              {if (is_on()) handle_execute ();}

    double              calc_temperature () const;
    double              calc_temperature (Atom_group const & ) const;
    
    Temperature_unit const& desired_temperature () const;
    void                set_desired_temperature (Temperature_unit const & t);

    virtual double      response_constant () const =0;
    virtual void        set_response_constant (double) =0;

protected:
    virtual void        handle_execute () =0;
};

}//MM

#endif //THERMOSTAT_H
