#ifndef VEFRL_H
#define VEFRL_H

#ifndef EFRL_H
#include "EFRL.h"
#endif

#ifndef LOCK_H
#include "Lock.h"
#endif  

namespace MM
{

class VEFRL : public EFRL
{
    int     update_list_;
    double  skin_;

public:
    explicit VEFRL (Prototype const &) {adopt_prototype (this);}
    explicit VEFRL () :   update_list_(1), skin_(.5) { }
    //explicit  VEFRL (MD_subject & subject) : EFRL (subject) { }
    char const* class_name () const {return "VEFRL";}
    char const* title      () const {return "Velocity Extended Forest-Ruth-Like";}
    char const* alias      () const {return "VEFRL";}
    MD_method * clone () const      {return new VEFRL;}

protected:
    double xi    () const {return  0.1644986515575760;}
    double lambda() const {return -0.02094333910398989;}
    double chi   () const {return  1.235692651138917;}

    virtual void        start  ()
    {
        Lock<MD> lock(simulation());
        MD_method::start ();
        step_N_ = 0;
        list (MD_subject::Whole, skin_);
        F ();
    }

    virtual void        step   ()
    {
        Lock<MD> lock(simulation());

        kick  (xi());
        drift ((1.-2.*lambda())/2.);

        if (step_N_ % update_list_ == 0)
            list (MD_subject::Whole, skin_);

        F ();
        kick  (chi());
        drift (lambda());
        F ();
        kick  (1.-2.*(chi()+xi()));
        drift (lambda());
        F ();
        kick  (chi());
        drift ((1.-2.*lambda())/2.);
        F ();
        kick  (xi());

        ++step_N_;
    }
};

}//MM

#endif //VEFRL_H
