#ifndef VELOCITY_EULER_H
#define VELOCITY_EULER_H

#ifndef EULER_H
#include "Euler.h"
#endif

#ifndef MD_H
#include "MD.h"
#endif

#ifndef LOCK_H
#include "Lock.h"
#endif  

#ifndef TIMER_H
#include "Timer.h"
#define TIME(ref) ;
#endif  

namespace MM
{

class Velocity_Euler : public Euler
{
    int     update_list_;
    double  skin_;

public:
    explicit Velocity_Euler (Prototype const &) {adopt_prototype (this);}
    explicit Velocity_Euler () :   update_list_(4), skin_(.5) { }
    char const* class_name () const {return "Velocity_Euler";}
    char const* title      () const {return "Velocity Euler";}
    char const* alias      () const {return "Euler-V";}
    MD_method * clone () const      {return new Velocity_Euler;}

protected:
    virtual void start ()
    {
        Lock<MD> lock(simulation());
        MD_method::start ();
        step_N_ = 0;
        list (MD_subject::Whole, skin_);
        F ();
    }

    virtual void        step   ()
    {
        TIME (" { ### ");
        Lock<MD> lock(simulation());
        TIME (" lock  ");

        if (step_N_ % update_list_ == 0)
            list (MD_subject::Whole, skin_);
        TIME (" list  ");

        F ();
        TIME (" F     ");
        kick  (1.);
        TIME (" kick  ");
        drift (1.);
        TIME (" drift ");

        ++step_N_;
    }
};

}//MM

#endif //VELOCITY_EULER_H
