#ifndef VELOCITY_LEAPFROG_H
#define VELOCITY_LEAPFROG_H

#ifndef LEAPFROG_H
#include "Leapfrog.h"
#endif

#ifndef LOCK_H
#include "Lock.h"
#endif  

namespace MM
{

class Velocity_leapfrog : public Leapfrog
{
    int     update_list_;
    double  skin_;

public:
    explicit Velocity_leapfrog (Prototype const &) {adopt_prototype (this);}
    explicit Velocity_leapfrog () :   update_list_(4), skin_(.5) { }
    //explicit Velocity_leapfrog (MD_subject & subject) : Leapfrog (subject) { }
    char const* class_name () const {return "Velocity_leapfrog";}
    char const* title      () const {return "Velocity leapfrog";}
    char const* alias      () const {return "Velocity leapfrog";}
    MD_method * clone () const      {return new Velocity_leapfrog;}

protected:
    virtual int         iterations () const {return simulation().steps()-1;}

    virtual void        start  ()
    {
        Lock<MD> lock(simulation());
        MD_method::start ();
        step_N_ = 0;
        list (MD_subject::Whole, skin_);
        F ();
        kick  (.5);
    }
    virtual void        step   ()
    {
        Lock<MD> lock(simulation());

        drift (1.);

        if (step_N_ % update_list_ == 0)
            list (MD_subject::Whole, skin_);

        F ();
        kick  (1.);

        ++step_N_;
    }
    virtual void        finish ()
    {
        Lock<MD> lock(simulation());
        drift (1.);
        F ();
        kick  (.5);
        MD_method::finish ();
    }
};

}//MM

#endif //VELOCITY_LEAPFROG_H
