#ifndef VELOCITY_VERLET_H
#define VELOCITY_VERLET_H

#ifndef LEAPFROG_H
#include "Leapfrog.h"
#endif

#ifndef LOCK_H
#include "Lock.h"
#endif  

namespace MM
{

class Velocity_verlet : public Leapfrog
{
    int     update_list_;
    double  skin_;

public:
    explicit Velocity_verlet (Prototype const &) {adopt_prototype (this);}
    explicit Velocity_verlet () :   update_list_(4), skin_(.5) { }
    //explicit Velocity_verlet (MD_subject & subject) : Leapfrog (subject) { }

    char const* class_name () const {return "Velocity_verlet";}
    char const* title      () const {return "Velocity Verlet";}
    char const* alias      () const {return "Velocity Verlet";}
    MD_method * clone () const      {return new Velocity_verlet;}

protected:
    virtual void start ()
    {
        Lock<MD> lock(simulation());
        MD_method::start ();
        step_N_ = 0;
        list (MD_subject::Whole, skin_);
        F ();
    }

    virtual void        step   ()
    {
        Lock<MD> lock(simulation());

        //F ();
        kick  (.5);
        drift (1.);

        if (step_N_ % update_list_ == 0)
            list (MD_subject::Whole, skin_);

        F ();
        kick  (.5);

        ++step_N_;
    }
};

}//MM

#endif //VELOCITY_VERLET_H
