#ifndef VERLET_H
#define VERLET_H

#ifndef LEAPFROG_H
#include "Leapfrog.h"
#endif

#ifndef LOCK_H
#include "Lock.h"
#endif  

namespace MM
{
 
class Verlet : public Leapfrog
{
    int     update_list_;
    double  skin_;

public:
    explicit Verlet (Prototype const &) {adopt_prototype (this);}
    explicit Verlet () :   update_list_(4), skin_(.5) { }
    //explicit Verlet (MD_subject & subject) : Leapfrog (subject) { }
    char const* class_name () const {return "Verlet";}
    char const* title      () const {return "Verlet";}
    char const* alias      () const {return "Verlet";}
    MD_method * clone () const      {return new Verlet;}

protected:
    virtual int         iterations () const {return simulation().steps()-1;}

    virtual void        start  ()
    {
        Lock<MD> lock(simulation());
        MD_method::start ();
        step_N_ = 0;
        list (MD_subject::Whole, skin_);
        //half_drift ();
        //kick        ();
        //half_drift ();
        drift (.5);
        F ();
        kick  (1.);
        drift (.5);
    }
    virtual void        step   ()
    {
        //fix
    }
    virtual void        finish ()
    {
        MD_method::finish ();
    }
};

}//MM

#endif //VERLET_H
