#ifndef ADD_BUILDER_H
#define ADD_BUILDER_H

namespace MM
{
class Model;

class Add_builder
{
public:
    virtual                ~Add_builder () {} 
    virtual Add_builder *   clone (Model & model) const =0;

    virtual void            load (const char * filename,
                                  const char *  file_type ="auto detect") =0;
    virtual void            reject () =0;
    virtual void            accept () =0;

    virtual bool            is_active () const =0;

    virtual bool            is_overlap_allowed () =0;
    virtual void            allow_overlap (bool on) =0;

    virtual void            up    () =0;
    virtual void            down  () =0;
    virtual void            right () =0;
    virtual void            left  () =0;
    virtual void            out   () =0;
    virtual void            in    () =0;

    virtual void            right_X () =0;
    virtual void            left_X  () =0;
    virtual void            right_Y () =0;
    virtual void            left_Y  () =0;
    virtual void            right_Z () =0;
    virtual void            left_Z  () =0;

    virtual double          translation_increment     () const =0;
    virtual double          rotation_increment        () const =0;
    virtual void            set_translation_increment (double value) =0;
    virtual void            set_rotation_increment    (double value) =0;

    virtual void            remove_overlap_in_additional_model (bool yes) =0;
    virtual void            move_current_model                 (bool yes) =0;
};

}//MM

#endif //ADD_BUILDER_H
