#ifndef ADD_BUILDER_IMPL_H
#define ADD_BUILDER_IMPL_H

#ifndef ADD_BUILDER_H
#include "Add_builder.h"
#endif

#ifndef MODEL_H
#include "Model.h"
#endif

#ifndef OWN_H
#include "Own.h"
#endif

#ifndef EDITOR_H
#include "Editor.h"
#endif

namespace MM
{
class Model;
class Prototype;

class Add_builder_impl : public Add_builder, public Editor
{
    Model &                 model_;
    Own <Model>             new_model_;
    double                  translation_increment_; // A
    double                  rotation_increment_;    // rad
    bool                    overlap_allowed_;
    Model *                 movable_model_;
    Model *                 immutable_model_;
    Model *                 overlapped_model_;

public:
    // Editor
    virtual Text const&     name () const;
    virtual void            handle_start_editing    ();
    virtual void            handle_finish_editing   ();
    virtual void            handle_cancel_editing   ();
    virtual void            handle_activate_editing ();
    //

    explicit                Add_builder_impl (Prototype const &);
    explicit                Add_builder_impl (Model & model);
    Add_builder *           clone (Model & model) const;

    void                    load (const char * filename,
                                  const char *  file_type ="auto detect");
    void                    reject ();
    void                    accept ();

    bool                    is_active () const;

    bool                    is_overlap_allowed ()   {return overlap_allowed_;}
    void                    allow_overlap (bool on);

    void                    up    ();
    void                    down  ();
    void                    right ();
    void                    left  ();
    void                    out   ();
    void                    in    ();

    void                    right_X ();
    void                    left_X  ();
    void                    right_Y ();
    void                    left_Y  ();
    void                    right_Z ();
    void                    left_Z  ();

    double                  translation_increment     () const;
    double                  rotation_increment        () const;
    void                    set_translation_increment (double value);
    void                    set_rotation_increment    (double value);

    void                    remove_overlap_in_additional_model (bool yes);
    void                    move_current_model                 (bool yes);

private:
    void                    user_interaction ();

    Model &                 previous_model () {return model_;}
    Model &                 new_model      () {return new_model_();}

    void                    check_overlap  (bool remove = false);
};

}//MM

#endif //ADD_BUILDER_IMPL_H
